﻿using Spectral1.DATA_ACCESS;
using Spectral1.PARSER;
using Spectral1_VBClassLibrary;
using System;
using System.Collections.Generic;
using System.IO;
using System.Windows.Forms;

namespace Spectral1.BUSINESS_LOGIC
{
    public class BL_All
    {
        #region "=========== DECLARATIONS ================"
        private PL_Main _plm;
        public BL_BodyResonanceFilter BLFilter;
        public BL_DGV BLDGV;
        public BL_KeyScaling BLKeyScaling;
        public BL_MIDI BLMIDI;
        public BL_Patch BLPatch;
        public BL_Spectral BLSpectral;
        public BL_WaveSet BLWaveSet;

        public DA_All DA = new DA_All();
        #endregion

        #region "=========== PROPERTIES ================"
        public bool patch_and_waveset_exists
        {
            get { return ((BLPatch.current_patch != null) && (BLWaveSet.current_waveform_set != null)); }
        }

        public bool patch_and_waveset_and_filter_exists
        {
            get { return ((BLPatch.current_patch != null) && (BLWaveSet.current_waveform_set != null) && (BLFilter.current_body_resonance_filter != null)); }
        }
        #endregion

        #region "=========== METHODS ================"
        public BL_All(PL_Main plm)
        {
            _plm = plm;

            BLFilter = new BL_BodyResonanceFilter(DA.CGS,DA.DASpectral);
            BLDGV = new BL_DGV(DA.CGS,DA.CGSS); 
            BLKeyScaling = new BL_KeyScaling(); 
            BLMIDI = new BL_MIDI(); 
            BLPatch = new BL_Patch(DA.CGS, DA.DASpectral,plm); 
            BLSpectral = new BL_Spectral(); 
            BLWaveSet = new BL_WaveSet(DA.CGS, DA.DASpectral,plm); 
        }

        public void execute_sdl_from_file(string file_path, bool notify_result)
        {
            c_dsl_execute dsle = new c_dsl_execute(_plm);
            dsle.execute_sdl_from_text(File.ReadAllText(file_path), notify_result);
        }

        public void execute_sdl_for_hammered_string_envelope()
        {
            c_dsl_execute dsle = new c_dsl_execute(_plm);
            string sdl_text = "";

            sdl_text += "Define.Patch" + Environment.NewLine;
            sdl_text += "{" + Environment.NewLine;
            sdl_text += "    ADSR.ConfigureSection(Section:Attack,Enabled:True,Duration:70,EndKSU:0%,EndKSL:0%,Sample:None,SampleMode:OneShot);" + Environment.NewLine;
            sdl_text += "    ADSR.ConfigureSection(Section:Decay,Enabled:True,Duration:300,EndKSU:0%,EndKSL:0%,Sample:None,SampleMode:OneShot);" + Environment.NewLine;
            sdl_text += "    ADSR.ConfigureSection(Section:Sustain,Enabled:True,Duration:60000,EndKSU:0%,EndKSL:0%,Sample:None,SampleMode:OneShot);" + Environment.NewLine;
            sdl_text += "    ADSR.ConfigureSection(Section:Release,Enabled:True,Duration:200,EndKSU:0%,EndKSL:0%,Sample:None,SampleMode:OneShot);" + Environment.NewLine;
            sdl_text += "    ADSR.ConfigureEnvelope(Section:Attack,Envelope:Amplitude,EnvelopeType:Exponential,Target:100.00%,TargetKSU:0%,TargetKSL:0%,LinearDelta:0,LinearDeltaKSU:0%,LinearDeltaKSL:0%,ExpMult:5%,ExpMultKSU:0%,ExpMultKSL:0%);" + Environment.NewLine;
            sdl_text += "    ADSR.ConfigureEnvelope(Section:Decay,Envelope:Amplitude,EnvelopeType:Exponential,Target:90.00%,TargetKSU:0%,TargetKSL:0%,LinearDelta:0,LinearDeltaKSU:0%,LinearDeltaKSL:0%,ExpMult:12%,ExpMultKSU:0%,ExpMultKSL:0%);" + Environment.NewLine;
            sdl_text += "    ADSR.ConfigureEnvelope(Section:Sustain,Envelope:Amplitude,EnvelopeType:Exponential,Target:90.00%,TargetKSU:0%,TargetKSL:0%,LinearDelta:0,LinearDeltaKSU:0%,LinearDeltaKSL:0%,ExpMult:12%,ExpMultKSU:0%,ExpMultKSL:0%);" + Environment.NewLine;
            sdl_text += "    ADSR.ConfigureEnvelope(Section:Release,Envelope:Amplitude,EnvelopeType:Exponential,Target:0.00%,TargetKSU:0%,TargetKSL:0%,LinearDelta:0,LinearDeltaKSU:0%,LinearDeltaKSL:0%,ExpMult:2%,ExpMultKSU:0%,ExpMultKSL:0%);" + Environment.NewLine;
            sdl_text += "}" + Environment.NewLine;

            dsle.execute_sdl_from_text(sdl_text,false);
        }
        #endregion





    }
}
